<!-- Step 1: Welcome -->
<div class="step-content step-1">
    <div class="text-center">
        <div class="mb-8">
            <img src="<?php echo e(asset('../public/img/logo-dark.png')); ?>" alt="Logo" class="mx-auto mb-6 rounded-2xl shadow-lg border-4 border-indigo-100"/>
            <div class="inline-flex items-center px-4 py-2 bg-emerald-50 text-emerald-700 rounded-full text-sm font-medium mb-6 shadow-sm">
                <span class="w-2 h-2 bg-emerald-500 rounded-full mr-2 animate-pulse"></span>
                Professional Installation Wizard
            </div>
        </div>
        <h1 class="mb-6 text-4xl md:text-5xl leading-tight text-slate-900 font-bold tracking-tight">
            Welcome to Our Script
        </h1>
        <p class="mb-6 text-xl md:text-2xl text-slate-600 font-medium max-w-2xl mx-auto">
            The installation wizard will help you set up everything in just a few simple steps.
        </p>
        <p class="mb-8 text-lg text-slate-500 max-w-xl mx-auto">
            Please follow the instructions below to complete the setup and start using your script with ease.
        </p>
        <div class="bg-gradient-to-r from-slate-50 to-blue-50 p-8 rounded-2xl mb-8 border border-slate-200 shadow-inner">
            <h4 class="mb-6 text-2xl md:text-3xl leading-tight text-slate-900 font-bold tracking-tight">What you'll need:</h4>
            <div class="grid md:grid-cols-3 gap-6 text-left">
                <div class="flex items-start space-x-3 p-4 bg-white rounded-xl shadow-sm border border-slate-100">
                    <div class="w-8 h-8 min-w-8 max-w-8 bg-blue-500 text-white rounded-lg flex items-center justify-center text-sm font-semibold mt-1 shadow-sm">1</div>
                    <div>
                        <h5 class="font-semibold text-slate-900 mb-1">Database Details</h5>
                        <p class="text-slate-600 text-sm">Connection credentials and settings</p>
                    </div>
                </div>
                <div class="flex items-start space-x-3 p-4 bg-white rounded-xl shadow-sm border border-slate-100">
                    <div class="w-8 h-8 min-w-8 max-w-8 bg-emerald-500 text-white rounded-lg flex items-center justify-center text-sm font-semibold mt-1 shadow-sm">2</div>
                    <div>
                        <h5 class="font-semibold text-slate-900 mb-1">Admin Account</h5>
                        <p class="text-slate-600 text-sm">Administrator user credentials</p>
                    </div>
                </div>
                <div class="flex items-start space-x-3 p-4 bg-white rounded-xl shadow-sm border border-slate-100">
                    <div class="w-8 h-8 min-w-8 max-w-8 bg-purple-500 text-white rounded-lg flex items-center justify-center text-sm font-semibold mt-1 shadow-sm">3</div>
                    <div>
                        <h5 class="font-semibold text-slate-900 mb-1">Site Configuration</h5>
                        <p class="text-slate-600 text-sm">Basic site preferences and settings</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="flex flex-wrap items-center justify-center gap-6 text-sm text-slate-500 mb-8">
            <div class="flex items-center bg-white px-4 py-2 rounded-full shadow-sm border border-slate-100">
                <div class="w-3 h-3 bg-green-500 rounded-full mr-2"></div>
                Secure Installation
            </div>
            <div class="flex items-center bg-white px-4 py-2 rounded-full shadow-sm border border-slate-100">
                <div class="w-3 h-3 bg-blue-500 rounded-full mr-2"></div>
                Auto-Configuration
            </div>
            <div class="flex items-center bg-white px-4 py-2 rounded-full shadow-sm border border-slate-100">
                <div class="w-3 h-3 bg-purple-500 rounded-full mr-2"></div>
                Quick Setup
            </div>
        </div>
    </div>
</div><?php /**PATH /home/cotlas-socialxi/htdocs/socialxi.cotlas.net/installer/views/steps/step1.blade.php ENDPATH**/ ?>