<?php
    $plan = $user->plan;
    $credit_summary = Credit::getCreditUsageSummary();
    $credit_summary = array_merge([
        'used' => 0,
        'limit' => 0,
        'is_unlimited' => false,
        'progress_value' => 0,
        'progress_label' => '0%',
        'quota_reached' => false,
        'message' => '',
    ], $credit_summary ?? []);

    $expired = false;
    if ($user->expiration_date && $user->expiration_date > 0) {
        $expired = $user->expiration_date < time();
    }
?>

<div>
    <div class="btn-group">
        <button type="button" class="btn btn-icon btn-clear btn-light rounded-circle dropdown-toggle dropdown-arrow-hide" data-bs-toggle="dropdown">
            <img src="<?php echo e(Media::url($user->avatar)); ?>" class="border-2 rounded-circle w-full h-full">
        </button>
        <div class="dropdown-menu dropdown-menu-end border-1 border-gray-300 w-100 max-w-220">
            <div class="mb-2 px-2">
                <div class="d-flex justify-content-start align-items-center gap-8 px-2">
                    <div class="d-flex flex-column gap-4 overflow-hidden">
                        <span class="text-gray-800 fw-6 text-truncate lh-1 mt-1">
                            <?php echo e($user->fullname); ?>

                        </span>
                        <span class="fs-11 text-gray-600 text-truncate fw-4 lh-1">
                            <?php echo e($user->email); ?>

                        </span>
                    </div>
                </div>
            </div>
            <div><hr class="dropdown-divider"></div>
            <div class="px-2">
                <a class="dropdown-item py-2 px-2 rounded d-flex gap-6" href="<?php echo e(url_app('profile')); ?>">
                    <span class="size-18 me-1 text-center"><i class="fa-light fa-user"></i></span>
                    <span><?php echo e(__("Profile")); ?></span>
                </a>
                <a class="dropdown-item py-2 px-2 rounded d-flex gap-6" href="<?php echo e(url_app('profile/plan')); ?>">
                    <span class="size-18 me-1 text-center"><i class="fa-light fa-box-open"></i></span>
                    <span><?php echo e(__("Plan")); ?></span>
                </a>
                <a class="dropdown-item py-2 px-2 rounded d-flex gap-6" href="<?php echo e(url_app('profile/billing')); ?>">
                    <span class="size-18 me-1 text-center"><i class="fa-light fa-ballot-check"></i></span>
                    <span><?php echo e(__("Billing")); ?></span>
                </a>
                <a class="dropdown-item py-2 px-2 rounded d-flex gap-6  d-none" href="<?php echo e(url_app('profile/settings')); ?>">
                    <span class="size-18 me-1 text-center"><i class="fa-light fa-gear"></i></span>
                    <span><?php echo e(__("Settings")); ?></span>
                </a>
            </div>
            <div><hr class="dropdown-divider"></div>
            <div class="px-3 d-flex flex-column gap-2">
                <div class="d-flex justify-content-between align-items-center gap-2">
                    <div class="d-flex flex-column gap-1 text-truncate-1">
                        <div class="fw-bold fs-13 text-truncate lh-1"><?php echo e($plan->name ?? __('No Plan')); ?></div>
                        <div class="fs-11 text-truncate lh-1
                            <?php if($user->expiration_date == -1): ?>
                                text-success
                            <?php elseif($expired): ?>
                                text-danger
                            <?php else: ?>
                                text-gray-600
                            <?php endif; ?>
                        ">
                            <?php if($user->expiration_date == -1): ?>
                                <?php echo e(__("Unlimited")); ?>

                            <?php elseif($expired): ?>
                                <?php echo e(__("Expired")); ?>

                            <?php elseif($user->expiration_date): ?>
                                <?php echo e(date_show($user->expiration_date)); ?>

                            <?php else: ?>
                                <?php echo e(__('N/A')); ?>

                            <?php endif; ?>
                        </div>
                    </div>
                    <div>
                        <a href="<?php echo e(route('app.profile', 'plan')); ?>" class="btn btn-primary btn-sm fs-12 w-100"><?php echo e(__("Upgrade")); ?></a>
                    </div>
                </div>
            </div>
            <div class="mt-2 mb-2 border-top pt-2 px-3">
                <div class="d-flex justify-content-between align-items-center mb-1">
                    <span class="fs-11 text-gray-600"><?php echo e(__('Credits used')); ?></span>
                    <span class="fs-11 fw-bold text-primary">
                        <?php if($credit_summary['is_unlimited']): ?>
                            <?php echo e(__('Unlimited')); ?>

                        <?php elseif($credit_summary['quota_reached']): ?>
                            100%
                        <?php else: ?>
                            <?php echo e($credit_summary['progress_label']); ?>

                        <?php endif; ?>
                    </span>
                </div>

                <div class="progress h-8" style="background:#eee;">
                    <div class="progress-bar
                        <?php if($credit_summary['is_unlimited']): ?>
                            bg-success
                        <?php elseif($credit_summary['quota_reached']): ?>
                            bg-danger
                        <?php else: ?>
                            bg-dark
                        <?php endif; ?>
                    "
                    style="width:
                        <?php if($credit_summary['is_unlimited'] || $credit_summary['quota_reached']): ?>
                            100%
                        <?php else: ?>
                            <?php echo e($credit_summary['progress_value']); ?>%
                        <?php endif; ?>
                    "></div>
                </div>

                <?php if(!empty($credit_summary['message'])): ?>
                    <div class="fs-11 text-muted mt-1"><?php echo e($credit_summary['message']); ?></div>
                <?php endif; ?>
            </div>
            <div><hr class="dropdown-divider"></div>
            <div class="px-3 py-2">
                <a class="btn btn-dark btn-sm w-100" href="<?php echo e(url('auth/logout')); ?>">
                    <i class="fa-light fa-right-from-bracket"></i> <?php echo e(__("Logout")); ?>

                </a>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/cotlas-socialxi/htdocs/socialxi.cotlas.net/modules/AppProfile/resources/views/partials/header-item.blade.php ENDPATH**/ ?>